function [Kernel,KernelLog,DecSub] = CreateKernel(hObject,handles,image,Add)
%% Create Kernel
% For deconvolution a kernel ( =pointspreadfunction PSF) is needed
% However, the following procedure depends on weather a vacuum ZLP was
% uploaded or not.
% In case it was, this uses the denoised ZLP. Else, it creates a kernel
% from the background region, selected in background.
% However, if two ZLP were uploaded, the user can decide eighter to use the fit from the ZLP subtraction
% or to create a new fit, as optimal subtraction and optimal kernel fit can differ.

% Also, to not shift the whole spectrum throu the array, it is important to shift the max of the
% ZLP to the start of the array.
% With periodic boundarys, this leads to a centering of the ZLP around the 1st position in the array.
%(In fourier space the overall phase of the ZLP is thus set to 0. By multiplying the spectra with phases =/= 0,
% it would lead to a shift of the spectra, which is obviously not wanted.)

% It is important to normalize the kernel to 1. Otherwise the overall counts of the spectrum would increase accordingly
% as a matter of multiplication.


%% Get handles
kernel    = get(handles.LoadPeak,'UserData');
kernel1   = kernel{1,1};
kernel2   = kernel{2,1}; 
Energies  = get(handles.ZLPAlign,'UserData');
EnergyRes = get(handles.Slider, 'SliderStep');
EnergyRes = EnergyRes(1);
Data      = get(handles.Background,'UserData');
Back      = Data{1};
DecMeth   = get(handles.DecMeth,'Value');
Fit       = load(fullfile(tempdir,'SubtrZLP.mat')).Data;
Name      = get(handles.DecMeth,'String');
Name      = Name{DecMeth};
FWHM      = get(handles.ShowFWHM,'UserData');
FitDispOpt= get(handles.FitDispOpt,'Value');
DiffMult  = str2double(get(handles.DiffMult,'String'));
Width     = str2double(get(handles.Width,'String'));
StartPar  = get(handles.DiffMult,'UserData');
EWidth    = StartPar{3,2};
EStart    = StartPar{3,1};

if DecMeth==5 && ~any(Name=='1')
    DecMeth=6;
end
%% Calculate Kernel
Energies = [Energies,linspace(Energies(1,end) + EnergyRes, Energies(1,end) + EnergyRes*(size(Add,3)-1),size(Add,3))];
DecSub   = 1;
UseFit   = 0;
switch DecMeth
    case 4
        DecSub        = 0;
        Img           = image;                                                          % the kernel should not be negative!
        Img(Img<0)    = 0;
        kernel        = Img(Back(2):Back(4),Back(1):Back(3),:);                         % uses selected background region
        kernel        = reshape(kernel,[size(kernel,1)*size(kernel,2),size(kernel,3)]); % of all background spectra
        kernel        = mean(kernel,1);                                                 % uses the mean
        kernel        = circshift(kernel,round(Energies(1)/EnergyRes),2);               % shifts the maximum position to the start of the array
        kernel        = kernel/sum(kernel,2);                                           % normalize kernel to 1
        Kernel        = zeros(size(image));                                             % for creation of a 3D kernel
        Kernel(1,1,:) = kernel;                                                         % ZLP is so small in lateral direction, that delta peak model is used here
        % for smallest structures ZLP could be modeled as 2D Gaussian function in lateral x-y direction
    case 5
        kernel1          = kernel1(1,:);
        kernel           = kernel1./sum(kernel1,2);
        kernel(kernel<0) = 0;                                                  % the kernel should not be negative!
        kernel           = circshift(kernel,round(Energies(1)/EnergyRes),2);      % shifts the maximum position to the start of the array
        kernel           = kernel/sum(kernel,2);                               % normalize kernel to 1
        Kernel           = zeros(size(image));
        Kernel(1,1,:)    = kernel;
        
    case 6
        kernel2          = kernel2(1,:);
        kernel           = kernel2./sum(kernel2,2);
        kernel(kernel<0) = 0;                                                  % the kernel should not be negative!
        kernel           = circshift(kernel,round(Energies(1)/EnergyRes),2);   % shifts the maximum position to the start of the array
        kernel           = kernel/sum(kernel,2);                               % normalize kernel to 1
        Kernel           = zeros(size(image));
        Kernel(1,1,:)    = kernel;
    otherwise
        
        if Fit{3}==DecMeth || (Fit{3}==6 && DecMeth==7)
            UseFit=1;
        else
            UseFit=0;
        end
        if UseFit
            answer = questdlg('Use the subtraction fit as kernel?','Kernel creation','Yes','No','No');
            switch answer
                case 'Yes'
                    UseFit=1;
                otherwise
                    UseFit=0;
            end
        end
        
        if UseFit
            kernel = Fit{1};
            kernel = reshape(kernel,[size(image,1)*size(image,2),size(image,3)]);
            kernel = mean(kernel,1);
        else
            Spec    = image./sum(image,3);
            FWHMOrg = FWHM;
            switch FitDispOpt
                case 1
                    Spec  = reshape(Spec,[size(image,1).*size(image,2),size(image,3)]);
                    Spec  = mean(Spec,1);
                    Spec  = Spec/max(Spec,[],2);
                case 2
                    Spec  = mean(Spec,2);
                    Spec  = reshape(Spec,[size(image,1),size(image,3)]);
                    Spec  = Spec./max(Spec,[],2);
                case 3
                    Spec  = reshape(Spec,[size(image,1).*size(image,2),size(image,3)]);
                    Spec  = Spec./max(Spec,[],2);
            end
            
            FWHM  = mean(FWHM,'all');
            Sigma = FWHM./(2*sqrt(2*log(2)));
            if isempty(EStart)
                EStart= -Width/4*mean(FWHM,'all');
                EWidth=  Width/2*mean(FWHM,'all');
            else
                EStart =  max(EStart,-mean(FWHM,'all')*Width/2);
                if EStart+EWidth>mean(FWHM,'all')*Width/2
                    EWidth =  mean(FWHM,'all')*Width/2;
                end
            end
            
            index1  = find(Energies<=EStart,1,'last');
            index2  = find(Energies>=EStart+EWidth,1,'first');
            spec    = mean(Spec,1);
            Peak    = spec(:,index1:index2);
            E       = Energies(:,index1:index2);
            options = optimset('Display','off');
            Fit     = zeros(size(Spec));
            
            switch DecMeth
                case 1
                    %% Fowler-Nordheim
                    x           = [ 1 ,0 , 0.2, 0.0825];
                    eqn         = @(x) sum((x(1).*exp(-(E-x(2))./abs(x(3)))./(1+exp(-(E-x(2))./abs(x(4))))-Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    Fit         = x(1).*exp(-(Energies-x(2))./abs(x(3)))./(1+exp(-(Energies-x(2))./abs(x(4))));
                    %% Gauss
                case 2
                    x           = [ 1 , 0 , Sigma, 10^(-5)];
                    eqn         = @(x) sum((x(1).*exp(-((E-x(2))./(sqrt(2).*x(3))).^2)+x(4)-Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    Fit         = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
                case 3
                    %% Weibull
                    x           =  [0.00044883, 1.7517 , -1.8317 ,14.204 ,  3.2323e-06];
                    eqn         = @(x) sum(( x(1) .* ((E-x(2))./x(3)).^(x(4)-1).* exp(((E-x(2))./x(3)).^x(4))+x(5) -Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    Fit         =  x(1) .* ((Energies-x(2))./x(3)).^(x(4)-1).* exp(((Energies-x(2))./x(3)).^x(4));
                case 7
                    %% Loaded Dual ZLP
                    
                    kernel1  = kernel1(1,:);
                    kernel1  = kernel1./max(kernel1,[],2);
                    
                    kernel2  = kernel2(1,:);
                    kernel2  = kernel2./max(kernel2,[],2);
                    
                    ZLPfit1  = kernel1(1,index1:index2);
                    ZLPfit2  = kernel2(1,index1:index2);
                    x        = [0.5 , 0.5];
                    eqn      = @(x) sum((abs(x(1)).*ZLPfit1+ abs(x(2)).*ZLPfit2 -Peak).^2);
                    x        = fminsearch(eqn,x,options);
                    Fit      = abs(x(1)).*kernel1 + abs(x(2)).*kernel2;
            end
            
            fit      = Fit./sum(Spec,2);
            clearvars Fit
            spec     = Spec./sum(Spec,2);
            res      = (spec-fit)*DiffMult;
            PosSpec  = res;
            PosSpec(PosSpec<0)=0;
            NegSpec  = res;
            NegSpec(PosSpec>0)=0;
            PosSpec  = mean(PosSpec,1);
            NegSpec  = mean(NegSpec,1);
            spec     = mean(spec,1);
            fit      = mean(fit,1);
            
            fig        = figure('Name','Select ZLP fit region - double click to confirm!');
            plot(Energies,spec,'Color','b');
            hold on
            plot(Energies,fit,'Color','m');
            plot(Energies,PosSpec,'Color','g');
            plot(Energies,NegSpec,'Color','r');
            plot(Energies,zeros(size(Energies)),'--','Color','k');
            legend('Normed mean Spectrum','Fit',['Pos. Difference x',num2str(DiffMult)],['Neg. Difference x',num2str(DiffMult)]);
            ylabel('mean Loss probability [a.u.]');
            xlabel('Loss energy [eV]');
            
            hold off
            xlim([-mean(FWHM,'all')*Width/2,mean(FWHM,'all')*Width/2]);
            ylim([-max(spec)/2,max(spec).*1.25])
            
            try
                Select  = drawrectangle('Position',[EStart,-max(spec)/2,EWidth,max(spec)/2+max(spec).*1.25],'Color','b','StripeColor','w');
                l1      = addlistener(Select,'MovingROI',@(src,evt) LiveFitKernel(src,evt,fig,handles,image./sum(image,3),Energies,FWHMOrg));
                l2      = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
                set(handles.LiveFitPanel,'UserData',{3,Select,fig,image./sum(image,3),Energies,FWHMOrg});
                guidata(hObject,handles)
                uiwait;
                set(handles.LiveFitPanel,'UserData',[]);
                guidata(hObject,handles)
                pos     = Select.Position;
                EStart  = pos(1);
                EWidth  = pos(3);
                Ind1      = pos(1);
                Ind2      = pos(1)+pos(3);
                Ind1      = find(Energies<= Ind1,1,'last');
                Ind2      = find(Energies>= Ind2,1,'first');
                delete(Select);
                close(fig);
                delete(l1);
                delete(l2);
            catch
                Kernel    = [];
                KernelLog = [];
                DecSub    = [];
                set(handles.LiveFitPanel,'UserData',[]);
                guidata(hObject,handles)
                clearvars -except Kernel KernelLog DecSub
                return
            end
            StartPar{3,2} = EWidth;
            StartPar{3,1} = EStart;
            set(handles.DiffMult,'UserData',StartPar);
            SizeZ         = size(image,3);
            
            %% Update Fit Method
            guidata(hObject, handles);
            
            DecMeth   = get(handles.DecMeth,'Value');
            if DecMeth==5 && ~any(Name=='1')
                DecMeth=6;
            end
            
            Img         = reshape(mean(Spec,1),[1,SizeZ]);
            Peak        = Img(Ind1:Ind2);
            switch DecMeth
                case 1
                    %% Fowler-Nordheim
                    x           = [ 1 ,0 , 0.2, 0.0825];
                    eqn         = @(x) sum((x(1).*exp(-(E-real(x(2)))./abs(x(3)))./(1+exp(-(E-real(x(2)))./abs(x(4))))-Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    kernel      = x(1).*exp(-(Energies-real(x(2)))./abs(x(3)))./(1+exp(-(Energies-real(x(2)))./abs(x(4))));
                case 2
                    %% Gauss
                    x           = [ 1 , 0 , mean(Sigma), 10^(-5)];
                    eqn         = @(x) sum((x(1).*exp(-((E-x(2))./(sqrt(2).*x(3))).^2)+x(4)-Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    kernel         = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
                case 3
                    %% Weibull
                    x           =  [0.00044883, 1.7517 , -1.8317 ,14.204 ,  3.2323e-06];
                    eqn         = @(x) sum(( x(1) .* ((E-x(2))./x(3)).^(x(4)-1).* exp(((E-x(2))./x(3)).^x(4))+x(5) -Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    kernel      =  x(1) .* ((Energies-x(2))./x(3)).^(x(4)-1).* exp(((Energies-x(2))./x(3)).^x(4));
                case 7
                    %% Loaded Dual ZLP
                    kernel1     = kernel1(1,:);
                    kernel2     = kernel2(1,:);
                    
                    kernel1     = kernel1(1,:);
                    kernel1     = kernel1./max(kernel1,[],2);
                    
                    kernel2     = kernel2(1,:);
                    kernel2     = kernel2./max(kernel2,[],2);
                    
                    ZLPfit1     = kernel1(1,Ind1:Ind2);
                    ZLPfit2     = kernel2(1,Ind1:Ind2);
                    x           = [0.5 , 0.5];
                    eqn         = @(x) sum((abs(x(1)).*ZLPfit1+ abs(x(2)).*ZLPfit2 -Peak).^2);
                    x           = fminsearch(eqn,x,options);
                    kernel      = abs(x(1)).*kernel1 + abs(x(2)).*kernel2;
            end
            
        end
        [~,Ind]       = max(kernel,[],2);
        kernel        = circshift(kernel,-Ind+1,2);
        kernel        = kernel./sum(kernel,2);
        kernel        = reshape(kernel,[1,1,size(kernel,2)]);
        Kernel        = zeros(size(image));
        Kernel(1,1,:) = kernel;
end

%% Create Kernel Log
if UseFit
    KernelLog = {['Method: ',Name,' with Subtr. fit as Kernel']};
elseif DecMeth<4
    KernelLog = {['Method: ', Name, '  |  StartVal: ',num2str(Energies(Ind1)),'eV |  EndVal: ',num2str(Energies(Ind2)),'eV']};
elseif DecMeth==4
    KernelLog = {['Method: ',Name,'  |  Back Edgepoints= [',num2str(Back(1)),' , ',num2str(Back(2)),' , ',num2str(Back(1)+Back(3)),' , ',num2str(Back(2)+Back(4)),' ]']};
elseif DecMeth==5 || DecMeth==6
    KernelLog = {['Method: ',Name]};
    if DecMeth==5
        ZLP1Log    = load(fullfile(tempdir,'DenZLP1Log.mat')).DenZLPLog;
        for i=1:size(ZLP1Log,1)
            ZLP1Log{i,:} = ['  ',ZLP1Log{i,:}];
        end
        KernelLog  = [KernelLog;ZLP1Log];
        KernelLog{end+1,1}=[];
    else
        ZLP2Log    = load(fullfile(tempdir,'DenZLP2Log.mat')).DenZLPLog;
        for i=1:size(ZLP2Log,1)
            ZLP2Log{i,:} = ['  ',ZLP2Log{i,:}];
        end
        KernelLog  = [KernelLog;ZLP2Log];
        KernelLog{end+1,1}=[];
    end
elseif DecMeth==7
    ZLP1Log    = load(fullfile(tempdir,'DenZLP1Log.mat')).DenZLPLog;
    ZLP2Log    = load(fullfile(tempdir,'DenZLP2Log.mat')).DenZLPLog;
    KernelLog = {['Method: ',Name,' with Kernel fit  |  StartVal: ', num2str(Energies(Ind1)),'eV  |  EndVal: ',num2str(Energies(Ind2)),'eV']};
    for i=1:size(ZLP1Log,1)
        ZLP1Log{i,:} = ['  ',ZLP1Log{i,:}];
    end
    KernelLog  = [KernelLog;ZLP1Log];
    KernelLog{end+1,1}=[];
    for i=1:size(ZLP2Log,1)
        ZLP2Log{i,:} = ['  ',ZLP2Log{i,:}];
    end
    KernelLog  = [KernelLog;ZLP2Log];
    KernelLog{end+1,1}=[];
end
clearvars -except Kernel KernelLog DecSub
end